from OpenGL.GL import *
import Image
import os
import traceback

from helpers import path


__all__ = ['TextureManager', 'Texture', 'TextureLoadError']

class TextureLoadError(Exception):pass

class _Texture:
    def __init__(self, file, target=GL_TEXTURE_2D):
        self.id = glGenTextures(1)
        self.target = target
        
        im = im_old = Image.open(file)
        im = im.transpose(Image.FLIP_TOP_BOTTOM)
        data=im.convert('RGBA').tostring()
        self.w,self.h=w,h=im.size
        
        self.bind()
        glTexParameterf(target, GL_TEXTURE_MAG_FILTER, GL_LINEAR)
        glTexParameterf(target, GL_TEXTURE_MIN_FILTER, GL_NEAREST)
        glTexImage2D(target, 0, GL_RGBA, w,h, 0, GL_RGBA, GL_UNSIGNED_BYTE, data);
        print 'Created tex %s*%s, id=%s, mode=%s'%(w, h, self.id, im_old.mode)
    #
    
    def bind(self):
        glBindTexture(self.target, self.id)
    #
    
    def unbind(self):
        glBindTexture(self.target, 0)
#

class TextureManager:
    def __init__(self):
        self.d = {}
    #
    
    def get(self, filename):
        filename=os.path.normpath(os.path.abspath(filename))
        
        if filename in self.d:
            return self.d[filename]
        else:
            try:
                self.d[filename] = _Texture(filename)
            except TextureLoadError:
                traceback.print_exc()
                self.d[filename] = self.get(path('ui/tex_load_failed.png'))
                raise TextureLoadError('Unable to open image %s'%filename)
            return self.d[filename]
    #
TextureManager = TextureManager()
Texture = TextureManager.get