import random
from pyglet.gl import *

from Texture import Texture

from helpers import *

# 0 1 2
# 3 4 5
# 6 7 8

class GestureArea:
    def __init__(self, x, y):   
        self.x = x
        self.y = y
        self.size = 80.
        
        self.reset()
    #
    
    def _check(self, *indices):
        mask = [i in indices for i in range(9)]
        value = [int(mask[i]==self.triggered[i]) for i in range(9)]
        #print value
        return sum(value) == 9
    #
    
    def _get_point_centers(self):
        for y in range(3)[::-1]: # in opengl down is up and up is down!
            for x in range(3):
                yield self.x + self.size/6. + x*self.size/3., \
                       self.y + self.size/6. + y*self.size/3., \
    
    def on_gesture_move(self, mouse):
        for i,(px,py) in enumerate(self._get_point_centers()):
            #print x,y, px,py
            if line_point_distance(mouse.x, mouse.y, mouse.ox, mouse.oy, px, py)<self.size/6.:
                self.triggered[i] = True
    #
    
    def reset(self):
        self.triggered = [False]*9
    
    def get_gesture(self):
        if self._check(1, 4, 7):
            return 'down'
        if self._check(1, 4, 3):
            return 'tcl'
        if self._check(3, 4, 5):
            return 'right'
        if self._check(1, 4, 5):
            return 'tcr'
        if self._check(3, 4, 7):
            return 'lcd'
        if self._check(5, 4, 7):
            return 'rcd'
#

def textured_quad(texture, x,y, wh, twh):
    if texture:
        texture.bind()
        glEnable(GL_TEXTURE_2D)
        
        glColor4f(1,1,1,1)
        
        glBegin(GL_QUADS)
        glTexCoord2f(0,0)
        glVertex2f(x-wh, y-wh)
        glTexCoord2f(0, twh)
        glVertex2f(x-wh, y+wh)
        glTexCoord2f(twh, twh)
        glVertex2f(x+wh, y+wh)
        glTexCoord2f(twh,0)
        glVertex2f(x+wh, y-wh)
        glEnd()
        glDisable(GL_TEXTURE_2D)
        texture.unbind()
    

class Tile:
    _texture = None
    _twh = 160/256.
    
    def __init__(self, x,y):
        self.x = x
        self.y = y
        self.width = 80
        self.gesture_area = GestureArea(x, y)
        
        if self._texture:
            self.texture = Texture(self._texture)
        else:
            self.texture = None
    #
    
    def draw(self):
        glColor4f(1,1,1,0)
        
        wh = self.width / 2
        x = self.x + self.width / 2
        y = self.y + self.width / 2
        
        textured_quad(Texture('tiles/tile160px.png'), x,y,wh, Tile._twh)
        textured_quad(self.texture, x,y,wh, self._twh)
        
        glPointSize(4)
        glBegin(GL_POINTS) 
        for i,(px,py) in enumerate(self.gesture_area._get_point_centers()):
            b=int(self.gesture_area.triggered[i])
            c=[
                (0,0,1,1),
                (1,1,0,1)
            ][b]
            glColor4f(*c)
            glVertex2f(px,py)
        glEnd()
            
#

class TileTD(Tile):
    _texture = 'tiles/straight2.png'
#

class TileLR(Tile):
    _texture = 'tiles/straight1.png'
#

class TileTL(Tile):
    _texture = 'tiles/grad.png'
#
class TileTR(Tile):
    _texture = 'tiles/corner1.png'
#
class TileBL(Tile):
    _texture = 'tiles/corner3.png'
#
class TileBR(Tile):
    _texture = 'tiles/corner4.png'
#

class TilePallo(Tile):
    _twh = 1
    _texture = 'tiles/pallo.png'
#


map = "xxx---xxx" \
      "xxxo|oxxx" \
      "xxx |    " \
      "x>--<-xxx" \
      "x|xoooxxx" \
      "x|> o    " \
      "xxx---xxx" \
      "xxxoooxxx" \
      "xxx o    "
#

mapping = {
    'x': Tile,
    '|': TileTD,
    '<': TileTL,
    '>': TileTR,
    '-': TileLR,
    'o': TilePallo,
    ' ': Tile
}

class Grid:
    def __init__(self, (w,h)):
        self.width = len(map)/9
        self.height = 9
        
        self.data = []
        
        for y in range(self.height):
            row = []
            for x in range(self.width):
                row.append(mapping[map[y*self.width+x]](x*80, y*80))
            self.data.append(row)
    #
    
    def enum_tiles(self):
        for y,row in enumerate(self.data):
            for x,tile in enumerate(row):
                yield tile
    #
    
    def draw(self):
        for y,row in enumerate(self.data):
            for x,tile in enumerate(row):
                tile.draw()
                #pass
#
