import pyglet
from pyglet.gl import *
from pyglet.window import key


from helpers import *

from Texture import *


from GameState import GameState

from Grid import *

class Camera:
    x=0
    y=0
#


class Basegame(GameState):
    def __init__(self, game):
        self.game=game
        
        self.grid = Grid((10,10))
        
        self.mouse_trail = []
    #
    
    def on_key_press(self, symbol, modifiers):
        if symbol==key.Q:
            self.game.map.generateVertexList(type=['wire', 'poly'][self.game.map.type=='wire'])
    #
    
    def update(self,dt):
        
        Forward=self.game.keyboard[key.W]-self.game.keyboard[key.S]
        Turn=self.game.keyboard[key.D]-self.game.keyboard[key.A]
        Fire=self.game.keyboard[key.SPACE]
        
        #self.pc.update(dt)
        
        if not self.game.mouse.buttons[1]:
            for tile in self.grid.enum_tiles():
                g = tile.gesture_area.get_gesture()
                tile.gesture_area.reset()
                if g:
                    print tile, g
                    if g == 'down':
                        tile.texture = Texture('tiles/straight2.png')
                    elif g == 'right':
						tile.texture = Texture('tiles/straight1.png')
                    elif g == 'tcl':
                        tile.texture = Texture('tiles/corner2.png')
                    elif g =='tcr':
                        tile.texture = Texture('tiles/corner1.png')
                    elif g =='lcd':
                        tile.texture = Texture('tiles/corner3.png')
                    elif g =='rcd':
                        tile.texture = Texture('tiles/corner4.png')
						
            self.mouse_trail = []
        else:
            self.mouse_trail.append((self.game.mouse.x, self.game.mouse.y))
            for tile in self.grid.enum_tiles():
                tile.gesture_area.on_gesture_move(self.game.mouse)
        

        #print self.pc.x,self.pc.y
    #
    
    def on_draw(self):
        self.game.window.clear()
        glEnable(GL_BLEND)
        glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)
        
        self.grid.draw()
        
        x,y=self.game.mouse.x, self.game.mouse.y
        #print x,y
        
        if 0:
            glColor4f(1,.7,0, 1)
            glBegin(GL_TRIANGLES)
            glVertex2f( x,y)				# Top
            glVertex2f(x+90,y-10)				# Bottom Left
            glColor4f(1,.7,0, 0)
            glVertex2f( x+90,y-20)				# Bottom Right
            glEnd();
        #
        
        glColor4f(1,1,1,1)
        glBegin(GL_LINES)
        p = None
        for c in self.mouse_trail:
            if p:
                glVertex2f(*p)
                glVertex2f(*c)
            p = c
        glEnd()
    #
#
        