# Test individual components of the easyleed module

import unittest
import numpy as np
import easyleed

# relative path to data dir
datadir = '../data/'
# epsilon used to compare floats
epsilon = 1e-10

class TestIO(unittest.TestCase):

    def setUp(self):
        self.imageloader = easyleed.filehandling.ImgImageLoader([datadir + 'dataAlCb/AlCb1.img'])
        self.image = np.load(datadir + 'unittesting/AlCb1.npy')

    def test(self):
        im, energy = self.imageloader.next()
        self.assertTrue(np.amax(np.abs(im - self.image)) < epsilon)

if __name__ == "__main__":
   unittest.main() 
