#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <GL/glew.h>
#include <GL/freeglut.h>

#define WindowTitle "Exercise 1, Task 2"

static const double PI = 3.14159265358979323846;

int WindowWidth = 400, WindowHeight = 400;
int numelem;

GLuint VbId1[2], VbId2[2];
GLuint VaRect[2];

void Initialize(int, char*[]);
void InitWindow(int, char*[]);
void ResizeFunction(int, int);
void KeyboardFunction(unsigned char, int, int);
void RenderFunction(void);
void Cleanup(void);
void CreateVBO(void);
void DestroyVBO(void);
void CreateShaders(void);
void DestroyShaders(void);

int main(int argc, char* argv[])
{
	Initialize(argc, argv);
	glutMainLoop();
	exit(EXIT_SUCCESS);
}

void Initialize(int argc, char* argv[])
{
	GLenum GlewInitResult;

	InitWindow(argc, argv);

	glewExperimental = GL_TRUE;
	GlewInitResult = glewInit();

	CreateShaders();
	CreateVBO();

	glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
}

void InitWindow(int argc, char* argv[])
{
	glutInit(&argc, argv);
	
	glutInitContextVersion(3, 3);
	glutInitContextFlags(GLUT_FORWARD_COMPATIBLE);
	glutInitContextProfile(GLUT_CORE_PROFILE);

	glutSetOption(GLUT_ACTION_ON_WINDOW_CLOSE, GLUT_ACTION_GLUTMAINLOOP_RETURNS );
	glutInitWindowSize(WindowWidth, WindowHeight);
	glutInitDisplayMode(GLUT_DEPTH | GLUT_SINGLE | GLUT_RGBA);

	glutCreateWindow(WindowTitle);

	glutReshapeFunc(ResizeFunction);
	glutKeyboardFunc(KeyboardFunction);
	glutDisplayFunc(RenderFunction);

	glutCloseFunc(Cleanup);
}

void ResizeFunction(int Width, int Height)
{
	WindowWidth = Width;
	WindowHeight = Height;
	glViewport(0, 0, WindowWidth, WindowHeight);
}

void KeyboardFunction(unsigned char key, int x, int y)
{
	switch (key)
	{
	case 27:
	case 'q':
	  	exit (0);
	break;
	}
}


void RenderFunction(void)
{

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

        glBindVertexArray(VaRect[0]);
	glDrawArrays(GL_LINE_LOOP, 0, 4);
        glBindVertexArray(VaRect[1]);
        glDrawArrays(GL_LINE_LOOP, 0, 12);
        glBindVertexArray(0);

	glFlush();

}

void Cleanup(void)
{
	DestroyShaders();
	DestroyVBO();
}

void CreateVBO(void)
{
	GLfloat Vertices1[] = {
	/*        x    y           */
		-0.5,-0.5, 0.0, 1.0,
		-0.5, 0.5, 0.0, 1.0,
		 0.5, 0.5, 0.0, 1.0,
                 0.5,-0.5, 0.0, 1.0
	};

	GLfloat Colors1[] = {
	/*       R    G    B   alpha */
		0.0, 1.0, 0.0, 1.0,
                0.0, 1.0, 0.0, 1.0,
                0.0, 1.0, 0.0, 1.0,
                0.0, 1.0, 0.0, 1.0,
	};


        typedef struct Vertex
        {
                float Position[4];
                float Color[4];
        } Vertex;

        Vertex Circle[50];
        float angle;
        int i, circle_points=12;


/*	2 VAOs: one for each geometry (square, circle) */
/*      2 buffers: the first one (0) for vertices, the second one (1) for colors */

	glGenVertexArrays(2, &VaRect[0]);
	glBindVertexArray(VaRect[0]);

	glGenBuffers(2, &VbId1[0]);

	glBindBuffer(GL_ARRAY_BUFFER, VbId1[0]);
	glBufferData(GL_ARRAY_BUFFER, sizeof(Vertices1), Vertices1, GL_STATIC_DRAW);
	glVertexAttribPointer(0, 4, GL_FLOAT, GL_FALSE, 0, 0);
        glEnableVertexAttribArray(0);

	glBindBuffer(GL_ARRAY_BUFFER, VbId1[1]);
	glBufferData(GL_ARRAY_BUFFER, sizeof(Colors1), Colors1, GL_STATIC_DRAW);
        glEnableVertexAttribArray(1);
	glVertexAttribPointer(1, 4, GL_FLOAT, GL_FALSE, 0, 0);
        glBindVertexArray(0);

        glBindVertexArray(VaRect[1]);
        glGenBuffers(2, &VbId2[0]);
        glBindBuffer(GL_ARRAY_BUFFER, VbId2[0]);

        for (i = 0; i < circle_points; i++) {
                angle = 2.0 * PI * i / circle_points;
                Circle[i].Position[0] = cos(angle) / 2.5+0.4; 
                Circle[i].Position[1] = sin(angle) / 2.5-0.4;
                Circle[i].Position[2] = 0.0; 
                Circle[i].Position[3] = 1.0; 
                Circle[i].Color[0] = 0.0;  
                Circle[i].Color[1] = 0.0;
                Circle[i].Color[2] = 1.0;
                Circle[i].Color[3] = 0.0;
        }

        glBufferData(GL_ARRAY_BUFFER, sizeof(Circle), Circle, GL_STATIC_DRAW);
        glVertexAttribPointer(0, 4, GL_FLOAT, GL_FALSE, 4*8, 0);
        glVertexAttribPointer(1, 4, GL_FLOAT, GL_FALSE, 4*8, (GLvoid*)16);
        glEnableVertexAttribArray(0);
        glEnableVertexAttribArray(1);

        glBindVertexArray(0);


}

void DestroyVBO(void)
{

	glDisableVertexAttribArray(1);
	glDisableVertexAttribArray(0);
	
	glBindBuffer(GL_ARRAY_BUFFER, 0);

	glDeleteBuffers(1, &VbId1[0]);


	glBindVertexArray(0);
	glDeleteVertexArrays(1, &VaRect[0]);

}

