#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <GL/glew.h>
#include <GL/freeglut.h>

#define WindowTitle "Exercise 1, Task 1a"

static const double PI = 3.14159265358979323846;

int WindowWidth = 400, WindowHeight = 400;
int numelem;

GLuint VbId1[2];
GLuint VaRect[1];

void Initialize(int, char*[]);
void InitWindow(int, char*[]);
void ResizeFunction(int, int);
void RenderFunction(void);
void Cleanup(void);
void CreateVBO(void);
void DestroyVBO(void);
void CreateShaders(void);
void DestroyShaders(void);

int main(int argc, char* argv[])
{
	Initialize(argc, argv);
	glutMainLoop();
	exit(EXIT_SUCCESS);
}

void Initialize(int argc, char* argv[])
{
	GLenum GlewInitResult;

	InitWindow(argc, argv);

	glewExperimental = GL_TRUE;
	GlewInitResult = glewInit();

	CreateShaders();
	CreateVBO();

	glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
}

void InitWindow(int argc, char* argv[])
{
	glutInit(&argc, argv);
	
	glutInitContextVersion(3, 3);
	glutInitContextFlags(GLUT_FORWARD_COMPATIBLE);
	glutInitContextProfile(GLUT_CORE_PROFILE);

	glutSetOption(GLUT_ACTION_ON_WINDOW_CLOSE, GLUT_ACTION_GLUTMAINLOOP_RETURNS );
	glutInitWindowSize(WindowWidth, WindowHeight);
	glutInitDisplayMode(GLUT_DEPTH | GLUT_SINGLE | GLUT_RGBA);

	glutCreateWindow(WindowTitle);

	glutReshapeFunc(ResizeFunction);
	glutDisplayFunc(RenderFunction);

	glutCloseFunc(Cleanup);
}

void ResizeFunction(int Width, int Height)
{
	WindowWidth = Width;
	WindowHeight = Height;
	glViewport(0, 0, WindowWidth, WindowHeight);
}

void RenderFunction(void)
{

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glDrawArrays(GL_LINE_LOOP, 0, 4);
	glFlush();

}

void Cleanup(void)
{
	DestroyShaders();
	DestroyVBO();
}

void CreateVBO(void)
{
	GLfloat Vertices[] = {
	/*        x    y           */
		-0.5,-0.5, 0.0, 1.0,
		-0.5, 0.5, 0.0, 1.0,
		 0.5, 0.5, 0.0, 1.0,
                 0.5,-0.5, 0.0, 1.0
	};

	GLfloat Colors[] = {
	/*       R    G    B   alpha */
		0.0, 1.0, 0.0, 1.0,
                0.0, 1.0, 0.0, 1.0,
                0.0, 1.0, 0.0, 1.0,
                0.0, 1.0, 0.0, 1.0,
	};

/*	buffer for vertices and buffer for colors */
	glGenVertexArrays(1, &VaRect[0]);
	glBindVertexArray(VaRect[0]);

	glGenBuffers(2, &VbId1[0]);
	glBindBuffer(GL_ARRAY_BUFFER, VbId1[0]);
	glBufferData(GL_ARRAY_BUFFER, sizeof(Vertices), Vertices, GL_STATIC_DRAW);
	glVertexAttribPointer(0, 4, GL_FLOAT, GL_FALSE, 0, 0);
	glEnableVertexAttribArray(0);

	glBindBuffer(GL_ARRAY_BUFFER, VbId1[1]);
	glBufferData(GL_ARRAY_BUFFER, sizeof(Colors), Colors, GL_STATIC_DRAW);
	glVertexAttribPointer(1, 4, GL_FLOAT, GL_FALSE, 0, 0);
	glEnableVertexAttribArray(1);

}

void DestroyVBO(void)
{

	glDisableVertexAttribArray(1);
	glDisableVertexAttribArray(0);
	
	glBindBuffer(GL_ARRAY_BUFFER, 0);

	glDeleteBuffers(1, &VbId1[0]);
	glDeleteBuffers(1, &VbId1[1]);


	glBindVertexArray(0);
	glDeleteVertexArrays(1, &VaRect[0]);

}

