#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <GL/glew.h>
#include <GL/freeglut.h>

GLuint  VertexShaderId, FragmentShaderId, ProgramId;

const GLchar* VertexShader =
{
	"#version 330\n"\

	"layout(location=0) in vec4 in_Position;\n"\
	"layout(location=1) in vec4 in_Color;\n"\
	"out vec4 ex_Color;\n"\

	"void main(void)\n"\
	"{\n"\
	"	gl_Position = in_Position;\n"\
	"	ex_Color = in_Color;\n"\
	"}\n"
};

const GLchar* FragmentShader =
{
	"#version 330\n"\

	"in vec4 ex_Color;\n"\
	"out vec4 out_Color;\n"\

	"void main(void)\n"\
	"{\n"\
	"	out_Color = ex_Color;\n"\
	"}\n"
};

void CreateShaders(void)
{

        VertexShaderId = glCreateShader(GL_VERTEX_SHADER);
        glShaderSource(VertexShaderId, 1, &VertexShader, NULL);
        glCompileShader(VertexShaderId);

        FragmentShaderId = glCreateShader(GL_FRAGMENT_SHADER);
        glShaderSource(FragmentShaderId, 1, &FragmentShader, NULL);
        glCompileShader(FragmentShaderId);

        ProgramId = glCreateProgram();
        glAttachShader(ProgramId, VertexShaderId);
        glAttachShader(ProgramId, FragmentShaderId);
        glLinkProgram(ProgramId);
        glUseProgram(ProgramId);

}

void DestroyShaders(void)
{

        glUseProgram(0);

        glDetachShader(ProgramId, VertexShaderId);
        glDetachShader(ProgramId, FragmentShaderId);

        glDeleteShader(FragmentShaderId);
        glDeleteShader(VertexShaderId);

        glDeleteProgram(ProgramId);

}

